/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.security;

import com.sun.deploy.security.CertStore;
import com.sun.deploy.security.CertUtils;
import com.sun.deploy.util.PerfLogger;
import java.io.IOException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.security.auth.x500.X500Principal;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class LazyRootStore {
    private CertStore browserRootStore = null;
    private CertStore jreRootStore = null;
    private boolean isBrowserRootStoreLoaded = false;
    private boolean isJRERootStoreLoaded = false;
    private X509Certificate ocspCertCA = null;
    private Set<X509Certificate> allRootCerts = new LinkedHashSet<X509Certificate>();
    private Set<X509Certificate> jreRootCerts = new LinkedHashSet<X509Certificate>();
    private Map<X500Principal, List<X509Certificate>> allTrustedSubjects = new HashMap<X500Principal, List<X509Certificate>>();
    private Map<X500Principal, List<PublicKey>> allTrustedSubjectKeys = new HashMap<X500Principal, List<PublicKey>>();

    LazyRootStore(CertStore certStore, CertStore certStore2) throws IOException, CertificateException, KeyStoreException, NoSuchAlgorithmException {
        this.browserRootStore = certStore;
        this.jreRootStore = certStore2;
    }

    private void loadBrowserStore() throws IOException, CertificateException, KeyStoreException, NoSuchAlgorithmException {
        if (this.browserRootStore != null && !this.isBrowserRootStoreLoaded) {
            PerfLogger.setTime("Security: Start loading browser Root certStore");
            this.browserRootStore.load();
            this.isBrowserRootStoreLoaded = true;
            PerfLogger.setTime("Security: End loading browser Root certStore");
            this.allRootCerts.addAll(this.browserRootStore.getCertificates());
        }
        this.createAllTrustedSubjects(this.allRootCerts);
    }

    private void loadJREStores() throws IOException, CertificateException, KeyStoreException, NoSuchAlgorithmException {
        if (this.isJRERootStoreLoaded) {
            return;
        }
        PerfLogger.setTime("Security: Start loading JRE root cert store");
        this.jreRootStore.load();
        this.jreRootCerts.addAll(this.jreRootStore.getCertificates());
        this.allRootCerts.addAll(this.jreRootStore.getCertificates());
        this.createAllTrustedSubjects(this.jreRootCerts);
        this.isJRERootStoreLoaded = true;
        PerfLogger.setTime("Security: End loading JRE root cert store");
    }

    TrustedRootResult getTrustAnchors(X509Certificate x509Certificate) throws IOException, CertificateException, KeyStoreException, NoSuchAlgorithmException {
        TrustedRootResult trustedRootResult;
        if (!this.isBrowserRootStoreLoaded) {
            this.loadBrowserStore();
        }
        if ((trustedRootResult = this.getMatchedResult(x509Certificate)) == null && !this.isJRERootStoreLoaded) {
            this.loadJREStores();
            trustedRootResult = this.getMatchedResult(x509Certificate);
        }
        return trustedRootResult;
    }

    private TrustedRootResult getMatchedResult(X509Certificate x509Certificate) {
        X500Principal x500Principal = x509Certificate.getIssuerX500Principal();
        X500Principal x500Principal2 = x509Certificate.getSubjectX500Principal();
        boolean bl = false;
        List<X509Certificate> list = null;
        if (this.allRootCerts.contains(x509Certificate) || this.allTrustedSubjectKeys.containsKey(x500Principal2) && this.allTrustedSubjectKeys.get(x500Principal2).contains(x509Certificate.getPublicKey())) {
            list = new LinkedList<X509Certificate>();
            list.add(x509Certificate);
            bl = true;
        } else if (this.allTrustedSubjects.containsKey(x500Principal)) {
            list = this.verifySignature(this.allTrustedSubjects.get(x500Principal), x509Certificate);
        }
        return list == null || list.isEmpty() ? null : new TrustedRootResult(list, bl);
    }

    private void createAllTrustedSubjects(Set<X509Certificate> set) {
        for (X509Certificate x509Certificate : set) {
            List<Object> list;
            List<Object> list2;
            X500Principal x500Principal = x509Certificate.getSubjectX500Principal();
            if (this.allTrustedSubjects.containsKey(x500Principal)) {
                list2 = this.allTrustedSubjects.get(x500Principal);
            } else {
                list2 = new LinkedList();
                this.allTrustedSubjects.put(x500Principal, list2);
            }
            list2.add(x509Certificate);
            if (this.allTrustedSubjectKeys.containsKey(x500Principal)) {
                list = this.allTrustedSubjectKeys.get(x500Principal);
            } else {
                list = new LinkedList();
                this.allTrustedSubjectKeys.put(x500Principal, list);
            }
            list.add(x509Certificate.getPublicKey());
        }
    }

    boolean containSubject(String string) throws IOException, CertificateException, KeyStoreException, NoSuchAlgorithmException {
        String string2;
        if (!this.isBrowserRootStoreLoaded) {
            this.loadBrowserStore();
        }
        for (X509Certificate x509Certificate : this.allRootCerts) {
            string2 = CertUtils.extractSubjectAliasName(x509Certificate);
            if (!string.equals(string2)) continue;
            this.ocspCertCA = x509Certificate;
            return true;
        }
        if (!this.isJRERootStoreLoaded) {
            this.loadJREStores();
            for (X509Certificate x509Certificate : this.jreRootCerts) {
                string2 = CertUtils.extractSubjectAliasName(x509Certificate);
                if (!string.equals(string2)) continue;
                this.ocspCertCA = x509Certificate;
                return true;
            }
        }
        this.ocspCertCA = null;
        return false;
    }

    X509Certificate getOCSPCert() {
        return this.ocspCertCA;
    }

    private List<X509Certificate> verifySignature(List<X509Certificate> list, X509Certificate x509Certificate) {
        LinkedList<X509Certificate> linkedList = new LinkedList<X509Certificate>();
        for (X509Certificate x509Certificate2 : list) {
            try {
                PublicKey publicKey = x509Certificate2.getPublicKey();
                x509Certificate.verify(publicKey);
                linkedList.add(x509Certificate2);
            }
            catch (Exception exception) {}
        }
        return linkedList;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class TrustedRootResult {
        private List<X509Certificate> matchedCAList;
        private boolean isAlreadyTrusted;

        TrustedRootResult(List<X509Certificate> list, boolean bl) {
            this.matchedCAList = list;
            this.isAlreadyTrusted = bl;
        }

        List<X509Certificate> getMatchedCAList() {
            return this.matchedCAList;
        }

        boolean isAlreadyTrusted() {
            return this.isAlreadyTrusted;
        }
    }
}

