/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.flightrecorder.ui.components.histogram.event;

import com.jrockit.mc.components.ui.services.IServiceLocator;
import com.jrockit.mc.flightrecorder.spi.IEvent;
import com.jrockit.mc.flightrecorder.spi.IEventType;
import com.jrockit.mc.flightrecorder.spi.IField;
import com.jrockit.mc.flightrecorder.spi.IView;
import com.jrockit.mc.flightrecorder.ui.components.column.GathererFactory;
import com.jrockit.mc.flightrecorder.ui.components.column.RetriverHolder;
import com.jrockit.mc.flightrecorder.ui.components.histogram.HistogramColumnDescriptorRepository;
import com.jrockit.mc.flightrecorder.ui.components.histogram.HistogramModel;

public final class EventHistogramModel
extends HistogramModel {
    public EventHistogramModel(HistogramColumnDescriptorRepository repository, IServiceLocator locator, IView cloud) {
        super(repository, locator, cloud);
    }

    @Override
    protected void build() {
        GathererFactory factory = this.getGathererFactory();
        IEventType eventType = null;
        IField groupBy = null;
        RetriverHolder mapper = null;
        for (IEvent event : this.getEventView()) {
            Object key;
            if (event.getEventType() != eventType) {
                groupBy = null;
                RetriverHolder newMapper = factory.getRetrivers(event.getEventType());
                if (newMapper != null) {
                    mapper = newMapper;
                    groupBy = newMapper.getGroupBy();
                    eventType = event.getEventType();
                } else {
                    groupBy = null;
                }
            }
            if (groupBy == null || (key = groupBy.getValue(event)) == null) continue;
            this.getHistogramItem(key).add(mapper, event);
            this.getHistogramItem(key).setUsed(true);
        }
    }
}

