/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.flightrecorder.ui.components.chart;

import com.jrockit.mc.common.persistence.PersistenceToolkit;
import com.jrockit.mc.common.persistence.Setting;
import com.jrockit.mc.components.ui.base.AbstractUIComponent;
import com.jrockit.mc.components.ui.behaviors.ICreateAccessiblePart;
import com.jrockit.mc.components.ui.components.UIScope;
import com.jrockit.mc.components.ui.services.IServiceLocator;
import com.jrockit.mc.flightrecorder.FlightRecording;
import com.jrockit.mc.flightrecorder.spi.IEvent;
import com.jrockit.mc.flightrecorder.spi.ITimeRange;
import com.jrockit.mc.flightrecorder.spi.IView;
import com.jrockit.mc.flightrecorder.ui.ViewModelBuilder;
import com.jrockit.mc.flightrecorder.ui.common.IEventConsumer;
import com.jrockit.mc.flightrecorder.ui.common.IOperativeSetAware;
import com.jrockit.mc.flightrecorder.ui.common.OperativeSetService;
import com.jrockit.mc.flightrecorder.ui.common.SimpleView;
import com.jrockit.mc.flightrecorder.ui.common.StartService;
import com.jrockit.mc.flightrecorder.ui.components.chart.ChartModelBuilder;
import com.jrockit.mc.flightrecorder.ui.components.chart.ChartViewer;
import com.jrockit.mc.flightrecorder.ui.components.chart.IRangeListener;
import com.jrockit.mc.flightrecorder.ui.components.chart.image.ChartImageBuilder;
import com.jrockit.mc.flightrecorder.ui.components.chart.image.ChartImageViewer;
import com.jrockit.mc.flightrecorder.ui.components.chart.model.FLRChartDescriptor;
import com.jrockit.mc.flightrecorder.ui.components.chart.model.FLRDescriptorToolkit;
import com.jrockit.mc.flightrecorder.ui.components.chart.table.ChartTableBuilder;
import com.jrockit.mc.flightrecorder.ui.components.chart.table.ChartTableViewer;
import com.jrockit.mc.flightrecorder.ui.components.inputs.Role;
import com.jrockit.mc.flightrecorder.ui.components.range.INavigatorSelectionChangeListener;
import com.jrockit.mc.flightrecorder.ui.components.range.RangeController;
import com.jrockit.mc.flightrecorder.ui.components.selection.EventTypeDescriptorRepository;
import com.jrockit.mc.flightrecorder.ui.views.types.ITypeVisibilityChange;
import com.jrockit.mc.flightrecorder.ui.views.types.ITypeVisibilitySupport;
import com.jrockit.mc.flightrecorder.util.TimeRange;
import com.jrockit.mc.greychart.ui.model.ChartDescriptor;
import com.jrockit.mc.greychart.ui.model.DataSeriesDescriptor;
import com.jrockit.mc.greychart.ui.views.DataSeriesLabelProvider;
import com.jrockit.mc.greychart.ui.views.legend.CheckBoxLegendViewer;
import com.jrockit.mc.greychart.ui.views.legend.LegendViewer;
import com.jrockit.mc.ui.UIPlugin;
import com.jrockit.mc.ui.accessibility.AccessibilityConstants;
import com.jrockit.mc.ui.accessibility.MCAccessibleListener;
import com.jrockit.mc.ui.accessibility.SimpleTraverseListener;
import java.util.ArrayList;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.accessibility.AccessibleListener;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class ChartComponent
extends AbstractUIComponent
implements ITypeVisibilityChange,
INavigatorSelectionChangeListener,
IOperativeSetAware,
IEventConsumer,
ICreateAccessiblePart,
ITypeVisibilitySupport {
    private boolean m_typeChangedAllowed;
    private ChartViewer<?> m_chartViewer;
    private RangeController m_rangeController;
    private TimeRange m_lastReceivedRange;

    public boolean initialize(IServiceLocator serviceLocator) {
        if (super.initialize(serviceLocator)) {
            ChartModelBuilder<?> builder = this.createModelBuilder();
            builder.setEventView(this.createView());
            builder.setOperativeSetEnabled(false);
            serviceLocator.registerService(ViewModelBuilder.class.getName(), builder);
            serviceLocator.registerService((Object)new OperativeSetService(serviceLocator));
            return true;
        }
        return false;
    }

    protected final IView createView() {
        return this.getRole().getCommander() != null ? new SimpleView(new ArrayList<IEvent>()) : this.getFlightRecording().createView();
    }

    private Role getRole() {
        Setting s = PersistenceToolkit.getSetting((Object)((Object)this.getChartDescriptor()));
        return Role.toRole((String)s.getChildObject("role", String.class));
    }

    private ChartModelBuilder<?> createModelBuilder() {
        if (UIPlugin.getDefault().getAccessibilityMode()) {
            return new ChartTableBuilder(this.getServiceLocator(), this.getChartDescriptor(), this.getComponentDescriptor().getName());
        }
        return new ChartImageBuilder(this.getServiceLocator(), this.getChartDescriptor(), this.getComponentDescriptor().getName());
    }

    public Control createAccessiblePart(Composite parent) {
        this.m_chartViewer = new ChartTableViewer(parent, this.getFormToolkit(), (ChartTableBuilder)this.getModelBuilder(), this.getChartDescriptor());
        return this.m_chartViewer.getControl();
    }

    public Composite createPart(Composite parent) {
        Composite client = this.getFormToolkit().createComposite(parent);
        client.setLayout((Layout)new FillLayout(512));
        this.hookAccessibility(client);
        ScrolledComposite sc = new ScrolledComposite(client, 256);
        sc.setExpandHorizontal(true);
        sc.setExpandVertical(true);
        Composite content = new Composite((Composite)sc, 0);
        content.setLayout((Layout)this.createClientLayout(1));
        int minWidth = 0;
        int minHeight = 0;
        if (this.hasVisibleLegendItems()) {
            GridData gd1 = new GridData(4, 4, true, false);
            LegendViewer lw = this.createLegendViewer(content, this.getFormToolkit());
            lw.getControl().setLayoutData((Object)gd1);
            Point p = lw.getControl().computeSize(-1, -1);
            minWidth = p.x;
            minHeight = p.y;
        }
        GridData gd3 = new GridData(4, 4, true, true);
        this.m_chartViewer = new ChartImageViewer(content, this.getFormToolkit(), (ChartImageBuilder)this.getModelBuilder());
        this.m_chartViewer.getControl().setLayoutData((Object)gd3);
        sc.setMinSize(Math.max(minWidth, 40), minHeight + 40);
        content.layout();
        sc.setContent((Control)content);
        return client;
    }

    private boolean hasVisibleLegendItems() {
        for (DataSeriesDescriptor dsd : this.getChartDescriptor().getDataSeriesDescriptors()) {
            if (!dsd.getShowInLegend()) continue;
            return true;
        }
        return false;
    }

    private GridLayout createClientLayout(int columnCount) {
        GridLayout layout = new GridLayout();
        layout.verticalSpacing = 2;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.numColumns = columnCount;
        return layout;
    }

    private void hookAccessibility(Composite composite) {
        composite.addTraverseListener((TraverseListener)new SimpleTraverseListener());
        MCAccessibleListener mc = new MCAccessibleListener();
        mc.setComponentType(AccessibilityConstants.COMPONENT_TYPE_GRAPH);
        mc.setName("Chart");
        composite.getAccessible().addAccessibleListener((AccessibleListener)mc);
    }

    private LegendViewer createLegendViewer(Composite parent, FormToolkit formToolkit) {
        LegendViewer legend = this.getChartDescriptor().getLockDataSeries() ? new LegendViewer(parent, formToolkit) : new CheckBoxLegendViewer(parent, formToolkit);
        legend.setContentProvider((IContentProvider)new ArrayContentProvider());
        legend.setLabelProvider((IBaseLabelProvider)new DataSeriesLabelProvider((ChartDescriptor)this.getChartDescriptor(), parent.getDisplay(), 12));
        legend.setInput((Object)this.getChartDescriptor().getLegendDescriptors());
        legend.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                CheckBoxLegendViewer.Selection selection = (CheckBoxLegendViewer.Selection)event.getSelection();
                ChartModelBuilder modelBuilder = (ChartModelBuilder)ChartComponent.this.getModelBuilder();
                modelBuilder.setEnabled((DataSeriesDescriptor)selection.getElement(), selection.isSelected());
                modelBuilder.scheduleRebuild();
            }
        });
        return legend;
    }

    private FLRChartDescriptor getChartDescriptor() {
        return (FLRChartDescriptor)((Object)this.getComponentDescriptor().getComponentSettings().getChildObject("chartDescriptor", FLRChartDescriptor.class));
    }

    @Override
    public void onChange(long startTime, long endTime) {
        this.m_lastReceivedRange = new TimeRange(startTime, endTime);
        if (this.m_chartViewer != null) {
            this.m_chartViewer.setRange(startTime, endTime);
            this.markDirty();
        }
    }

    public void hide() {
    }

    protected OperativeSetService getOperativeSetService() {
        return (OperativeSetService)this.getServiceLocator().getService(OperativeSetService.class);
    }

    private FlightRecording getFlightRecording() {
        return (FlightRecording)this.getServiceLocator().getService(FlightRecording.class);
    }

    public void initializeUI() {
        super.initializeUI();
        if (this.m_lastReceivedRange == null) {
            this.m_lastReceivedRange = new TimeRange(this.getStartService().getStartTimestamp(), this.getStartService().getEndTimestamp());
        }
        UIScope c = (UIScope)this.getServiceLocator().getService(UIScope.class);
        this.m_rangeController = new RangeController(c, this, (ITimeRange)this.m_lastReceivedRange);
        this.m_typeChangedAllowed = this.calcTypeChange();
        this.m_chartViewer.setRange(this.m_lastReceivedRange.getStartTimestamp(), this.m_lastReceivedRange.getEndTimestamp());
        this.m_chartViewer.addRangeListener(new IRangeListener(){

            @Override
            public void onRangeChange(Number start, Number end) {
                ChartComponent.this.m_rangeController.setRange((ITimeRange)new TimeRange(start.longValue(), end.longValue()), true);
            }
        });
    }

    private boolean calcTypeChange() {
        for (DataSeriesDescriptor ds : this.getChartDescriptor().getDataSeriesDescriptors()) {
            if (!FLRDescriptorToolkit.isUserFilterConstrained(ds)) continue;
            return true;
        }
        return false;
    }

    private StartService getStartService() {
        return (StartService)this.getServiceLocator().getService(StartService.class);
    }

    @Override
    public void onTypeVisibilityChange() {
        if (this.isUserFilterConstranied()) {
            this.markDirty();
        }
    }

    private boolean isUserFilterConstranied() {
        for (DataSeriesDescriptor dsd : this.getChartDescriptor().getDataSeriesDescriptors()) {
            if (!FLRDescriptorToolkit.isUserFilterConstrained(dsd)) continue;
            return true;
        }
        return false;
    }

    public void refresh() {
        this.m_chartViewer.refresh();
    }

    @Override
    public void operativeSetChange() {
        this.markDirty();
    }

    @Override
    public boolean isTypeChangeEnabled() {
        return this.m_typeChangedAllowed;
    }

    @Override
    public void consumeEvents(Iterable<IEvent> events, Role role) {
        if (this.getRole().listensTo(role)) {
            IView view = this.getModelBuilder().getView();
            if (view instanceof SimpleView) {
                SimpleView s = (SimpleView)view;
                s.setRange(ITimeRange.INFINITE_RANGE);
                s.setEvents(events);
            }
            this.markDirty();
        }
    }

    private ViewModelBuilder<?> getModelBuilder() {
        return (ViewModelBuilder)this.getServiceLocator().getService(ViewModelBuilder.class);
    }

    @Override
    public EventTypeDescriptorRepository getEventTypeDescriptorRepository() {
        EventTypeDescriptorRepository repo = new EventTypeDescriptorRepository();
        for (DataSeriesDescriptor dsd : this.getChartDescriptor().getLeftYAxis().getDataSeries()) {
            EventTypeDescriptorRepository etr = FLRDescriptorToolkit.getEventTypeRepository(dsd);
            repo.getDescriptors().addAll(etr.getDescriptors());
            if (!etr.getUserFilterConstrained()) continue;
            repo.setUserFilterConstrained(true);
        }
        return repo;
    }
}

