/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.components.ui.settings;

import com.jrockit.mc.common.persistence.Setting;
import com.jrockit.mc.components.ui.settings.BooleanInput;
import com.jrockit.mc.components.ui.settings.IInput;
import com.jrockit.mc.components.ui.util.StatusProvider;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.swt.widgets.Composite;

public class CompositeInput
extends StatusProvider
implements IInput {
    private final List<IInput> m_inputs = new ArrayList<IInput>();
    private final String m_name;
    private final String m_key;

    public CompositeInput() {
        this(null, null);
    }

    public CompositeInput(String name) {
        this(name, null);
    }

    public CompositeInput(String name, String key) {
        this.m_name = name;
        this.m_key = key;
    }

    public void addInputs(List<IInput> inputs) {
        for (IInput input : inputs) {
            this.addInput(input);
        }
    }

    public void addInput(IInput input) {
        this.m_inputs.add(input);
        this.addStatusProvider(input);
    }

    public void removeInput(IInput input) {
        this.m_inputs.remove(input);
        this.removeStatusProvider(input);
    }

    public List<IInput> getInputs() {
        return Collections.unmodifiableList(this.m_inputs);
    }

    @Override
    public void setSetting(Setting setting) {
        for (IInput input : this.getInputs()) {
            input.setSetting(this.getChildSetting(setting));
        }
        this.refresh();
    }

    protected Setting getChildSetting(Setting setting) {
        if (this.m_key == null) {
            return setting;
        }
        return setting.getChild(this.m_key);
    }

    @Override
    public void refresh() {
        for (IInput input : this.getInputs()) {
            input.refresh();
        }
    }

    @Override
    public void create(Composite parent, int horizontalSpan) {
        for (IInput input : this.getInputs()) {
            if (!(input instanceof BooleanInput)) continue;
            input.create(parent, horizontalSpan);
        }
        for (IInput input : this.getInputs()) {
            if (input instanceof BooleanInput) continue;
            input.create(parent, horizontalSpan);
        }
    }

    @Override
    public void dispose() {
        for (IInput input : this.getInputs()) {
            input.dispose();
        }
        this.clear();
    }

    @Override
    public String getName() {
        return this.m_name;
    }

    @Override
    public boolean isEnabled() {
        for (IInput i : this.getInputs()) {
            if (i.isEnabled()) continue;
            return false;
        }
        return true;
    }

    @Override
    public void setEnabled(boolean enabled) {
        for (IInput input : this.getInputs()) {
            input.setEnabled(enabled);
        }
    }
}

